local dragons={}
local dragon={images={},baseScale=2.5,scaleSpeed=2,visible=false,startTime=24.6,switchTime=32.1,endTime=39.6,current=nil,scale=1.5}
local wobble={amplitude=30,speed=4}
function dragons.load()
dragon.images[1]=love.graphics.newImage("dragon1.png")
dragon.images[2]=love.graphics.newImage("dragon2.png")
end
function dragons.update(dt, timePassed)
if timePassed >= dragon.startTime and timePassed < dragon.endTime then
if not dragon.visible then
dragon.visible=true
end
if timePassed < dragon.switchTime then
dragon.current=dragon.images[1]
else
dragon.current=dragon.images[2]
end
dragon.scale=dragon.baseScale * (1 + 0.1 * math.sin(dragon.scaleSpeed * timePassed))
else
if dragon.visible then
dragon.visible=false
dragon.current=nil
end end end
function dragons.draw()
if dragon.visible and dragon.current then
love.graphics.push()
local centerX=1920/2
local centerY=1080/2 - 110
love.graphics.translate( centerX + wobble.amplitude * math.sin(wobble.speed * love.timer.getTime()), centerY + wobble.amplitude * math.cos(wobble.speed * love.timer.getTime()) )
love.graphics.scale( dragon.scale, dragon.scale )
love.graphics.setColor( 1, 1, 1, math.abs(math.sin(love.timer.getTime()*2)) )
love.graphics.draw( dragon.current, -dragon.current:getWidth()/2, -dragon.current:getHeight()/2 )
love.graphics.pop()
end end
return dragons
